"""This class uses a simple heuristic to select actions for the agent when the agent is evil:
 vote yes on parties with evil players
 propose parties with the highest probability of the evil players
"""

from enum import Enum
from agent_base import ATEAM

# class ATEAM(Enum):
#     GOOD = 1
#     EVIL = 2


class EvilHeuristicOracle(object):
    def __init__(self, role):
        self.role = role    # good is 1, evil is 2. This will be of type ATEAM

    def get_action(self, state):
        """place holder for action selection funciton. Right now this does nothing"""
        return {}
    
    def opinion_on_party(self, party, probabilities):
        """"TODO think about what this will look like for an evil player"""
        raise NotImplementedError("Must be implemented in subclass")
    
    def vote_for_party(self, party, probabilities, selfname):
        """"Vote for a party that has you in it"""
        # TODO we will have to change this to a more complex heuristic
        if len(party) == 2: # always agree to the first party
            return True
        if probabilities == None:
            raise ValueError("Probabilities are None")
        if selfname in party:
            return True
        return False
    
    def propose_party(self, party_size, probabilities):
        """"This will propose a party with the highest n good players"""
        players_in_oreder = self.order_players(probabilities)
        return players_in_oreder[:party_size]
    
    def vote_for_quest(self):
        """if you are evil, fail the quest if you are good, pass the quest"""
        if self.role == ATEAM.EVIL:
            return False
        return True

    def order_players(self, probabilities):
        """Order players by the probability of being good"""
        return sorted(probabilities.keys(), key=lambda x: probabilities[x]['good'], reverse=True)